/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*
 * Abstract:
 * 	Declaration of error code ranges for the various OpenSM modules.
 *
 * Environment:
 * 	Linux User Mode
 *
 * $Revision: 1.4 $
 */

#ifndef _OSM_ERRORS_H_
#define _OSM_ERRORS_H_

/*
	Generic Request Controller
	0100 - 01FF

	Node Info Receive Controller
	0200 - 02FF

	Generic Requester
	0300 - 03FF

	Node Info Receiver
	0400 - 04FF

	Node Description Receiver
	0500 - 05FF

	Node Description Receive Controller
	0600 - 06FF

	Port Info Receiver
	0700 - 07FF

	Port Info Receive Controller
	0800 - 08FF

	Mad Pool
	0900 - 09FF

	SM
	1000 - 10FF

	SM MAD Controller
	1100 - 11FF

	VL15 Interface
	1200 - 12FF

	Switch Info Receive Controller
	1300 - 13FF

	Switch Info Receiver
	1400 - 14FF

	State Manager
	1500 - 15FF

	State Manager Controller
	1600 - 16FF

	LID Manager
	1700 - 17FF

	Link Manager
	1800 - 18FF

	Drop Manager
	1900 - 19FF

	Linear Forwarding Receive Controller
	2000 - 20FF

	Linear Forwarding Receiver
	2100 - 21FF

	Vendor Specific
	2200 - 22FF

	SMInfo Receive Controller
	2300 - 23FF

	SMInfo Info Receiver
	2400 - 24FF

	Generic Responder
	2500 - 25FF

	Linear Forwarding Receive Controller
	2600 - 26FF

	Linear Forwarding Receiver
	2700 - 27FF
	
	SA MAD controller
	2800 - 28FF

	Node Record Controller
	2900 - 29FF

	PortInfo Record Controller
	3000 - 30FF

	Link Record Controller
	3100 - 31FF

	Path Record Controller
	3200 - 32FF
	
	SMInfo Record Controller
	3300 - 33FF
	
	Multicast Record Controller
	3400 - 34FF

	Unicast Manager
	3500 - 35FF

	Multicast Manager
	3600 - 36FF

	SA Response
	3700 - 37FF

	Link Record Receiver
	3800 - 38FF

	Multicast Forwarding Receive Controller
	3900 - 39FF

	Multicast Forwarding Receiver
	4000 - 40FF

	SMInfo Record Receiver
	4100 - 41FF

	PortInfo Record Receiver
	4200 - 42FF

	Service Record Receiver
	4300 - 43FF

*/

#endif /* _OSM_ERRORS_H_ */
